% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{query_chroms}
\alias{query_chroms}
\title{Query the chromosomes or seqnames from a vector of BED files}
\usage{
query_chroms(bedfiles, nthreads = NULL)
}
\arguments{
\item{bedfiles}{The vector of BED file paths}

\item{nthreads}{Set number of threads to use overriding the
\code{"iscream.threads"} option. See \code{?set_threads} for more information.}
}
\value{
A vector of seqnames
}
\description{
Query the chromosomes or seqnames from a vector of BED files
}
\examples{
bedfiles <- system.file("extdata", package = "iscream") |>
  list.files(pattern = "[a|b|c|d].bed.gz$", full.names = TRUE)
query_chroms(bedfiles)
}
