% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_1kg.R
\name{stack1kg}
\alias{stack1kg}
\title{couple together a group of VCFs}
\usage{
stack1kg(chrs = as.character(1:22), index = FALSE, useEBI = FALSE)
}
\arguments{
\item{chrs}{a vector of chromosome names for extraction from 1000 genomes
VCF collection}

\item{index}{logical telling whether VcfStack should attempt to create the
local index; for 1000 genomes, the tbi are in the cloud and will be used by
readVcf so FALSE is appropriate}

\item{useEBI}{logical(1) defaults to FALSE ... if TRUE, use tabix-indexed vcf from EBI,
but in July 2022 the EBI FTP site does not respond.  If FALSE, the AWS Open Data
access path is used}
}
\value{
VcfStack instance
}
\description{
couple together a group of VCFs
}
\note{
The seqinfo component of returned stack will have NA for genome.
Please set it manually; for useEBI=TRUE this would be GRCh38; very likely so
for useEBI=FALSE, but this should be checked.
}
\examples{
if (interactive()) {
  st1 = stack1kg()
  st1
  }
}
