% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/align.R
\name{align_harmony}
\alias{align_harmony}
\alias{align_by_grouping}
\title{Enforce additional alignment of cell clusters beyond the direct differential embedding}
\usage{
align_harmony(
  fit,
  design = fit$alignment_design,
  ridge_penalty = 0.01,
  max_iter = 10,
  ...,
  verbose = TRUE
)

align_by_grouping(
  fit,
  grouping,
  design = fit$alignment_design,
  ridge_penalty = 0.01,
  preserve_position_of_NAs = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{fit}{a \code{lemur_fit} object}

\item{design}{a specification of the design (matrix or formula) that is used
for the transformation. Default: \code{fit$design_matrix}}

\item{ridge_penalty}{specification how much the flexibility of the transformation
should be regularized. Default: \code{0.01}}

\item{max_iter}{argument specific for \code{align_harmony}. The number of iterations. Default: \code{10}}

\item{...}{additional parameters that are passed on to relevant functions}

\item{verbose}{Should the method print information during the fitting. Default: \code{TRUE}.}

\item{grouping}{argument specific for \code{align_by_grouping}. Either a vector which assigns
each cell to one group or a matrix with \code{ncol(fit)} columns where the rows are a soft-assignment
to a cluster (i.e., columns sum to \code{1}). \code{NA}'s are allowed.}

\item{preserve_position_of_NAs}{argument specific for \code{align_by_grouping}.
Boolean flag to decide if \code{NA}s in the \code{grouping} mean that these cells should stay where they are (if
possible) or if they are free to move around. Default: \code{FALSE}}
}
\value{
The \code{fit} object with the updated \code{fit$embedding} and \code{fit$alignment_coefficients}.
}
\description{
Enforce additional alignment of cell clusters beyond the direct differential embedding
}
\examples{
data(glioblastoma_example_data)
fit <- lemur(glioblastoma_example_data, design = ~ patient_id + condition,
             n_emb = 5, verbose = FALSE)
# Creating some grouping for illustration
cell_types <- sample(c("tumor cell", "neuron", "leukocyte"), size = ncol(fit), replace = TRUE)
fit_al1 <- align_by_grouping(fit, grouping = cell_types)

# Alternatively, use harmony to automatically group cells
fit_al2 <- align_harmony(fit)
fit_al2

# The alignment coefficients are a 3D array
fit_al2$alignment_coefficients

}
