limpca
================

<!-- badges: start -->

[![R-CMD-check](https://github.com/ManonMartin/limpca/actions/workflows/check-standard.yaml/badge.svg)](https://github.com/ManonMartin/limpca/actions/workflows/check-standard.yaml)
<!-- badges: end -->

The web page of the package can be accessed here:
<https://manonmartin.github.io/limpca/>

`limpca` applies a GLM (General Linear Model) version of ASCA and APCA
to analyse multivariate sample profiles generated by an experimental
design. ASCA/APCA provide powerful visualization tools for multivariate
structures in the space of each effect of the statistical model linked
to the experimental design and contrarily to MANOVA, it can deal with
mutlivariate datasets having more variables than observations. `limpca`
presents different advantages compared to other software in this field:
(1) it is able to treat any balanced or unbalanced experimental design
for fixed categorical factors, (2) it offers optimized methods to
calculate effect importance and test their significance, (3) it allows
the user to represent data and ASCA/APCA results with various and rich
ggplot2-based graphical outputs that are highly customizable and (4) the
package is open to future extensions to more sophisticated statistical
models.

## Installation

Installation from Bioconductor:

```r
if (!requireNamespace("BiocManager", quietly = TRUE))
    install.packages("BiocManager")
    
BiocManager::install("limpca")
```


## Additional information

For any enquiry, you can open an
[issue](https://github.com/ManonMartin/limpca/issues) on Github or send
an email to the package authors: <bernadette.govaerts@uclouvain.be> ;
<michel.thiel@uclouvain.be> or <manon.martin@uclouvain.be>.
