% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatConverter.R
\name{Convert,GInteractions-method}
\alias{Convert,GInteractions-method}
\alias{Convert}
\alias{Convert,data.frame-method}
\alias{Convert,Pairs-method}
\alias{Convert,ANY-method}
\alias{readvalidPairs}
\title{Convert GInteractions to linkSet}
\usage{
\S4method{Convert}{GInteractions}(x, baitCol = NULL, ...)

\S4method{Convert}{data.frame}(x, source = "data.frame", baitCol = "gene", oeCol = "peak", ...)

\S4method{Convert}{Pairs}(x, baitCol = NULL, ...)

\S4method{Convert}{ANY}(x, baitCol = NULL, ...)

readvalidPairs(file, njobs = 1, format = "validPairs")
}
\arguments{
\item{x}{An object of unsupported class}

\item{baitCol}{A character string specifying the column to use for bait naming}

\item{...}{Additional arguments (not used)}

\item{source}{The source of the data frame, either "data.frame" or "chicane"}

\item{oeCol}{The column name in the data frame that contains the other end information}

\item{file}{A character string specifying the path to the validPairs file or 4DN pairs file}

\item{njobs}{An integer specifying the number of threads to use for reading the file}

\item{format}{A character string specifying the format of the file, either "validPairs" or "pair". Pair format should be "readID chr1 pos1 chr2 pos2 strand1 strand2". And validPairs should be "readID chr1 pos1 strand1 chr2 pos2 strand2".}
}
\value{
A linkSet object

A linkSet object

A linkSet object

Nothing, throws an error

A GInteractions object
}
\description{
Convert other data formats to linkSet. Currently supported: GInteractions, data.frame.
}
\examples{
library(InteractionSet)
gi <- GInteractions(anchor1 = c(1, 2), anchor2 = c(3, 4), 
                    regions = GRanges(seqnames = c("chr1", "chr1", "chr2", "chr2"),
                                      ranges = IRanges(start = c(100, 200, 300, 400), width = 50)))
linkset_obj <- Convert(gi)
linkset_obj

df <- data.frame(
  gene = c("gene1", "gene2"),
  peak = c("chr1:1000-2000", "chr2:1500-2500"),
  score = c(5.5, 6.0)
)
linkset_obj <- Convert(df, source = "data.frame", baitCol = "gene", oeCol = "peak")
linkset_obj
}
