% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plotGenomicRanges,linkSet-method}
\alias{plotGenomicRanges,linkSet-method}
\title{Plot genomic ranges for linkSet objects}
\usage{
\S4method{plotGenomicRanges}{linkSet}(
  linkset,
  showBait = NULL,
  showOE = NULL,
  x.range = NULL,
  score.col = "count",
  show.rect = TRUE,
  extend.base = 10000,
  ...,
  bait_col = "red",
  oe_col = "DeepSkyBlue3",
  default_col = "grey",
  vjust = NULL,
  linejoin = "mitre",
  na.rm = FALSE,
  minimal_width = 0.01,
  show.legend = NA,
  inherit.aes = TRUE,
  link_plot_on_top = FALSE,
  arrow.size = 0.05,
  remove_x_axis = FALSE,
  plot.height = 0.4,
  plot.space = 0.1,
  log.scale = TRUE
)
}
\arguments{
\item{linkset}{A linkSet object to plot}

\item{showBait}{Vector of bait regions to display (NULL for all)}

\item{showOE}{Vector of other end regions to display (NULL for all)}

\item{x.range}{Range of x-axis to display}

\item{score.col}{Column name for coloring links}

\item{show.rect}{Whether to show rectangles for regions}

\item{extend.base}{Base pairs to extend the plot}

\item{...}{Additional arguments}

\item{bait_col}{Color for bait regions}

\item{oe_col}{Color for other end regions}

\item{default_col}{Default color}

\item{vjust}{Vertical justification}

\item{linejoin}{Line join style}

\item{na.rm}{Whether to remove NA values}

\item{minimal_width}{Minimal width for regions}

\item{show.legend}{Whether to show legend}

\item{inherit.aes}{Whether to inherit aesthetics}

\item{link_plot_on_top}{Whether to draw links on top}

\item{arrow.size}{Size of arrows}

\item{remove_x_axis}{Whether to remove x axis}

\item{plot.height}{Height of the plot}

\item{plot.space}{Space between plots}

\item{log.scale}{Whether to use log scale for colors}
}
\value{
A ggplot object
}
\description{
This function visualizes the genomic interactions in a linkSet object,
showing the bait and other end regions as well as the links between them.
}
\examples{
data(linkExample)
plotGenomicRanges(linkExample, extend.base = 10)
}
