% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\name{regionsBait<-}
\alias{regionsBait<-}
\title{Set Bait Regions}
\usage{
regionsBait(x) <- value
}
\arguments{
\item{x}{A linkSet object}

\item{value}{A GRanges object containing the new bait regions}
}
\value{
The modified linkSet object
}
\description{
Replace the regions corresponding to the bait anchors of a linkSet object
}
\details{
Set Bait Regions for linkSet Object
}
\examples{
# Create example data
gr1 <- GRanges("chr1", IRanges(1:3, width=1))
gr2 <- GRanges("chr1", IRanges(4:6, width=1))
linkset_obj <- linkSet(gr1, gr2)

# Create new bait regions
new_bait <- GRanges("chr1", IRanges(7:9, width=1))

# Replace bait regions
regionsBait(linkset_obj) <- new_bait
}
