% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsea.R
\name{lsea}
\alias{lsea}
\alias{significant_lipidsets}
\alias{plot_class_enrichment}
\alias{plot_enrichment}
\title{Lipid set enrichment analysis (LSEA)}
\usage{
lsea(
  de.results,
  rank.by = c("logFC", "P.Value", "adj.P.Val"),
  min_size = 2,
  ...
)

significant_lipidsets(enrich.results, p.cutoff = 0.05, size.cutoff = 2)

plot_class_enrichment(de.results, significant.sets, measure = "logFC")

plot_enrichment(
  de.results,
  significant.sets,
  annotation = c("class", "length", "unsat"),
  measure = "logFC"
)
}
\arguments{
\item{de.results}{Output of \code{\link[=de_analysis]{de_analysis()}}.}

\item{rank.by}{Statistic used to rank the lipid list.  Default is \code{logFC}.}

\item{min_size}{Minimum number of molecules in a set to be included
in enrichment.}

\item{...}{Extra parameters passed to \code{\link[fgsea:fgsea]{fgsea::fgsea()}}.}

\item{enrich.results}{Output of \code{\link[=lsea]{lsea()}}.}

\item{p.cutoff}{Significance threshold.  Default is \code{0.05}.}

\item{size.cutoff}{Minimum number of lipids in a set tested for enrichment.
Default is \code{2}.}

\item{significant.sets}{List of significantly changed lipid sets
(output of \code{\link[=significant_lipidsets]{significant_lipidsets()}}).}

\item{measure}{Which measure to plot the distribution of: logFC, P.Value,
Adj.P.Val. Default is \code{logFC}.}

\item{annotation}{Which lipid set collection to plot.}
}
\value{
\code{lsea} returns enrichment results (data.frame) as returned from
\code{\link[fgsea:fgsea]{fgsea::fgsea()}}.
The results also contain the following attributes: \itemize{
\item de.results    Original de.results input.
\item rank.by   Measure used to rank lipid molecules.
\item sets   Lipid sets tested, with their member molecules.
}

\code{significant_lipidsets} returns a list of character vectors of
significantly enriched sets for each contrast.

\code{plot_enrichment} returns a ggplot object.
}
\description{
Lipid set enrichment analysis (LSEA)
}
\section{Functions}{
\itemize{
\item \code{significant_lipidsets()}: gets a list of significantly changed lipid sets

\item \code{plot_enrichment()}: is usually used to look at log2 fold change
distribution of lipids in each class, chain length or unsaturation,
marking significantly enriched sets. It can also be used to plot \code{P.Value}
or \code{Adj.P.Val}.

}}
\examples{
data(data_normalized)
de_results <- de_analysis(
  data_normalized,
  HighFat_water - NormalDiet_water,
  measure = "Area"
)
enrich_results <- lsea(
  de_results,
  rank.by = "logFC", min_size = 4, nperm = 1000
)
sig_lipidsets <- significant_lipidsets(enrich_results)
plot_enrichment(de_results, sig_lipidsets, annotation="class")
plot_enrichment(de_results, sig_lipidsets, annotation="length")
}
