% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{normalize_istd}
\alias{normalize_istd}
\title{Normalize each class by its corresponding internal standard(s).}
\usage{
normalize_istd(data, measure = "Area", exclude = "blank", log = TRUE)
}
\arguments{
\item{data}{LipidomicsExperiment object.}

\item{measure}{Which measure to use as intensity, usually Area,
Area Normalized or Height. Default is \code{Area}.}

\item{exclude}{Samples to exclude, can be either: \cr
"blank" - automatically detected blank samples and exclude them
logical vector with the same length as samples. Default.}

\item{log}{whether the normalized values should be log2 transformed. Default
is \code{TRUE}.}
}
\value{
A LipidomicsExperiment object with normalized values. Each molecule
is normalized against the internal standard from the same class.
}
\description{
Normalize each class by its corresponding internal standard(s).
Lipid classes are normalized using corresponding internal standard(s)
of the same lipid class. If no corresponding internal standard is found
the average of all measured internal standards is used instead.
}
\examples{
datadir <- system.file("extdata", package = "lipidr")
filelist <- list.files(datadir, "data.csv", full.names = TRUE)
d <- read_skyline(filelist)
clinical_file <- system.file("extdata", "clin.csv", package = "lipidr")
d <- add_sample_annotation(d, clinical_file)
d_summarized <- summarize_transitions(d, method = "average")

# Normalize data that have been summarized (single value per molecule).
data_norm_istd <- normalize_istd(
  d_summarized,
  measure = "Area", exclude = "blank", log = TRUE
)
}
