% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize.R
\name{summarize_transitions}
\alias{summarize_transitions}
\title{Summarize transitions}
\usage{
summarize_transitions(data, method = c("max", "average"))
}
\arguments{
\item{data}{LipidomicsExperiment object.}

\item{method}{Choose to summarize multiple transitions by taking the average
or maximum intensity. Default is \code{max}}
}
\value{
A LipidomicsExperiment object with single intensities per lipid molecule
}
\description{
Calculate a single intensity for molecules with multiple transitions,
by determining the average or maximum intensity.
}
\examples{
datadir <- system.file("extdata", package = "lipidr")
filelist <- list.files(datadir, "data.csv", full.names = TRUE)
d <- read_skyline(filelist)
clinical_file <- system.file("extdata", "clin.csv", package = "lipidr")
d <- add_sample_annotation(d, clinical_file)
d_summarized <- summarize_transitions(d, method = "average")
}
