% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lisaClust.R
\name{lisaClust}
\alias{lisaClust}
\title{Use k-means clustering to cluster local indicators of spatial association. For other clustering use lisa.}
\usage{
lisaClust(
  cells,
  k = 2,
  Rs = NULL,
  imageID = "imageID",
  cellType = "cellType",
  spatialCoords = c("x", "y"),
  regionName = "region",
  cores = 1,
  window = "convex",
  window.length = NULL,
  whichParallel = "imimageID",
  sigma = NULL,
  lisaFunc = "K",
  minLambda = 0.05,
  BPPARAM = BiocParallel::SerialParam()
)
}
\arguments{
\item{cells}{A SingleCellExperiment, SpatialExperiment or data frame that contains at least the
variables x and y, giving the  coordinates of each cell, imageID and cellType.}

\item{k}{The number of regions to cluster.}

\item{Rs}{A vector of the radii that the measures of association should be calculated.}

\item{imageID}{The column which contains image identifiers.}

\item{cellType}{The column which contains the cell types.}

\item{spatialCoords}{The columns which contain the x and y spatial coordinates.}

\item{regionName}{The output column for the lisaClust regions.}

\item{cores}{Number of cores to use for parallel processing, or a BiocParallel 
MulticoreParam or SerialParam object.}

\item{window}{Should the window around the regions be 'square', 'convex' or 'concave'.}

\item{window.length}{A tuning parameter for controlling the level of concavity
when estimating concave windows.}

\item{whichParallel}{Should the function use parallization on the imageID or
the cellType.}

\item{sigma}{A numeric variable used for scaling when filting inhomogeneous L-curves.}

\item{lisaFunc}{Either "K" or "L" curve.}

\item{minLambda}{Minimum value for density for scaling when fitting inhomogeneous L-curves.}

\item{BPPARAM}{\{DEPRECATED\} A BiocParalell MulticoreParam or SerialParam object.}
}
\value{
A matrix of LISA curves
}
\description{
Use k-means clustering to cluster local indicators of spatial association. For other clustering use lisa.
}
\examples{
library(spicyR)
library(SingleCellExperiment)
# Read in data
isletFile <- system.file("extdata", "isletCells.txt.gz", package = "spicyR")
cells <- read.table(isletFile, header = TRUE)
cellExp <- SingleCellExperiment(
    assay = list(intensities = t(cells[, grepl(names(cells), pattern = "Intensity_")])),
    colData = cells[, !grepl(names(cells), pattern = "Intensity_")]
)

# Cluster cell types
markers <- t(assay(cellExp, "intensities"))
kM <- kmeans(markers, 8)
colData(cellExp)$cluster <- paste("cluster", kM$cluster, sep = "")

# Generate LISA
cellExp <- lisaClust(cellExp,
    k = 2,
    imageID = "ImageNumber",
    cellType = "cluster",
    spatialCoords = c("Location_Center_X", "Location_Center_Y")
)

}
