% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allClasses.R, R/allGenerics.R, R/allAccessor.R
\docType{class}
\name{eqtlSet-class}
\alias{eqtlSet-class}
\alias{eqtlSet}
\alias{tissue}
\alias{eqtlId}
\alias{eqtlRange}
\alias{eqtlGene}
\alias{tissue,eqtlSet-method}
\alias{eqtlId,eqtlSet-method}
\alias{eqtlRange,eqtlSet-method}
\alias{eqtlGene,eqtlSet-method}
\title{eqtlSet Class}
\usage{
tissue(x)

eqtlId(x)

eqtlRange(x)

eqtlGene(x)

\S4method{tissue}{eqtlSet}(x)

\S4method{eqtlId}{eqtlSet}(x)

\S4method{eqtlRange}{eqtlSet}(x)

\S4method{eqtlGene}{eqtlSet}(x)
}
\arguments{
\item{x}{An eqtlSet object}
}
\value{
Object of class eqtlSet
}
\description{
eqtlSet Class contains information for eqtl-gene association,
 gene identifier, position of SNPs, etc.
}
\section{Slots}{

\describe{
\item{\code{tissue}}{character; name of the cell/tissue of the eQTL study}

\item{\code{eqtlId}}{character; name of the SNPs}

\item{\code{eqtlRange}}{GenomicRanges; position of the SNPs}

\item{\code{gene}}{character; gene identifier}
}}

\examples{
require(GenomicRanges)
brain.file <- system.file("extdata", "eqtl/brain.gtex.txt", 
    package="loci2path")
tab <- read.table(brain.file, stringsAsFactors=FALSE, header=TRUE)
eqtlRange <- GRanges(seqnames=Rle(tab$snp.chr), 
    ranges=IRanges(start=tab$snp.pos, 
    width=1))
brain.eset <- eqtlSet(tissue="brain",
    eqtlId=tab$snp.id,
    eqtlRange=eqtlRange,
    gene=as.character(tab$gene.entrez.id))
tissue(brain.eset)
head(eqtlId(brain.eset))
eqtlRange(brain.eset)
head(eqtlGene(brain.eset))
}
