% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/loci2pathResult-methods.R
\docType{methods}
\name{getPathDescription}
\alias{getPathDescription}
\alias{getPathDescription,loci2pathResult-method}
\title{Extract description for enriched pathways from query result and 
geneSet object}
\usage{
getPathDescription(res, ...)

\S4method{getPathDescription}{loci2pathResult}(res, geneset)
}
\arguments{
\item{res}{query result from function query.egset.list()}

\item{\dots}{additional params}

\item{geneset}{A \code{geneSet} object}
}
\value{
a vector of gene set description from \code{geneSet} description 
slot
}
\description{
This function extracts the pathway description from geneSet object.
}
\examples{
result <- query(query.gr=query.gr, 
  loci=eset.list, path=biocarta)
path.des <- getPathDescription(result, biocarta)
}
