% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mafObjects.R
\name{MAF}
\alias{MAF}
\title{Construct an MAF object}
\usage{
MAF(nonSyn = NULL, syn = NULL, clinicalData = NULL, verbose = TRUE)
}
\arguments{
\item{nonSyn}{non-synonymous variants as a data.table or any object that can be coerced into a data.table (e.g: data.frame, GRanges)}

\item{syn}{synonymous variants as a data.table or any object that can be coerced into a data.table (e.g: data.frame, GRanges)}

\item{clinicalData}{Clinical data associated with each sample/Tumor_Sample_Barcode in MAF. Could be a text file or a data.frame. Requires at least a column with the name `Tumor_Sample_Barcode` Default NULL.}

\item{verbose}{Default TRUE}
}
\description{
Constructor function which takes non-synonymous, and synonymous variants along with an optional clinical information and generates an MAF object
}
\examples{
laml.maf <- system.file("extdata", "tcga_laml.maf.gz", package = "maftools")
laml_dt = data.table::fread(input = laml.maf)
laml.clin = system.file('extdata', 'tcga_laml_annot.tsv', package = 'maftools') #Clinical data
# Just for demonstration
nsyn_vars = laml_dt[Variant_Classification \%in\% "Missense_Mutation"]
syn_vars = laml_dt[Variant_Classification \%in\% "Silent"]
maftools::MAF(nonSyn = nsyn_vars, syn = syn_vars, clinicalData = laml.clin)
}
