% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setMaf.R
\name{setdiffMAF}
\alias{setdiffMAF}
\alias{intersectMAF}
\title{Set Operations for MAF objects}
\usage{
setdiffMAF(x, y, mafObj = TRUE, refAltMatch = TRUE, ...)

intersectMAF(x, y, refAltMatch = TRUE, mafObj = TRUE, ...)
}
\arguments{
\item{x}{the first `MAF` object.}

\item{y}{the second `MAF` object.}

\item{mafObj}{Return output as an `MAF` object. Default `TRUE`}

\item{refAltMatch}{Set operations are done by matching ref and alt alleles in addition to loci (Default). If FALSE only loci (chr, start, end positions) are matched.}

\item{...}{other parameters passing to `subsetMaf` for subsetting operations.}
}
\value{
subset table or an object of class \code{\link{MAF-class}}. If no overlaps found returns `NULL`
}
\description{
Set Operations for MAF objects
}
\examples{
laml.maf <- system.file("extdata", "tcga_laml.maf.gz", package = "maftools")
laml <- read.maf(maf = laml.maf)
x <- subsetMaf(maf = laml, tsb = c('TCGA-AB-3009'))
y <- subsetMaf(maf = laml, tsb = c('TCGA-AB-2933'))
setdiffMAF(x, y)
intersectMAF(x, y) #Should return NULL due to no common variants
}
