% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survGroup.R
\name{survGroup}
\alias{survGroup}
\title{Predict genesets associated with survival}
\usage{
survGroup(
  maf,
  top = 20,
  genes = NULL,
  geneSetSize = 2,
  minSamples = 5,
  clinicalData = NULL,
  time = "Time",
  Status = "Status",
  verbose = TRUE,
  plot = FALSE
)
}
\arguments{
\item{maf}{an \code{\link{MAF}} object generated by \code{\link{read.maf}}}

\item{top}{If genes is \code{NULL} by default used top 20 genes}

\item{genes}{Manual set of genes}

\item{geneSetSize}{Default 2}

\item{minSamples}{minimum number of samples to be mutated to be considered for analysis. Default 5}

\item{clinicalData}{dataframe containing events and time to events. Default looks for clinical data in annotation slot of \code{\link{MAF}}.}

\item{time}{column name contining time in \code{clinicalData}}

\item{Status}{column name containing status of patients in \code{clinicalData}. must be logical or numeric. e.g, TRUE or FALSE, 1 or 0.}

\item{verbose}{Default TRUE}

\item{plot}{Default FALSE If TRUE, generate KM plots of the genesets combinations.}
}
\description{
Predict genesets associated with survival
}
\examples{
laml.maf <- system.file("extdata", "tcga_laml.maf.gz", package = "maftools")
laml.clin <- system.file("extdata", "tcga_laml_annot.tsv", package = "maftools")
laml <- read.maf(maf = laml.maf,  clinicalData = laml.clin)
survGroup(maf = laml, top = 20, geneSetSize = 1, time = "days_to_last_followup", Status = "Overall_Survival_Status", plot = FALSE)
}
