% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcga.R
\name{tcgaLoad}
\alias{tcgaLoad}
\title{Loads a TCGA cohort}
\usage{
tcgaLoad(
  study = NULL,
  source = c("MC3", "Firehose"),
  repo = c("github", "gitee")
)
}
\arguments{
\item{study}{Study names to load. Use  \code{\link{tcgaAvailable}} to see available options.}

\item{source}{Source for MAF files. Can be \code{MC3} or \code{Firehose}. Default \code{MC3}. Argument may be abbreviated (M or F)}

\item{repo}{one of "github" (default) and "gitee".}
}
\value{
An object of class MAF.
}
\description{
Loads the user mentioned TCGA cohorts
}
\details{
The function loads curated and pre-compiled MAF objects from TCGA cohorts. TCGA data are obtained from two sources namely, Broad Firehose repository, and MC3 project.
}
\examples{
# Loads TCGA LAML cohort (default from MC3 project)
tcgaLoad(study = "LAML")
# Loads TCGA LAML cohort (from Borad Firehose)
tcgaLoad(study = "LAML", source = "Firehose")
}
\references{
Scalable Open Science Approach for Mutation Calling of Tumor Exomes Using Multiple Genomic Pipelines Kyle Ellrott, Matthew H. Bailey, Gordon Saksena, et. al. Cell Syst. 2018 Mar 28; 6(3): 271–281.e7.
}
\seealso{
\code{\link{tcgaAvailable}}
}
