% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeGisticSummary.R
\name{write.GisticSummary}
\alias{write.GisticSummary}
\title{Writes GISTIC summaries to output tab-delimited text files.}
\usage{
write.GisticSummary(gistic, basename = NULL)
}
\arguments{
\item{gistic}{an object of class \code{GISTIC} generated by \code{readGistic}}

\item{basename}{basename for output file to be written.}
}
\value{
None. Writes output as tab delimited text files.
}
\description{
Writes GISTIC summaries to output tab-delimited text files.
}
\examples{
all.lesions <- system.file("extdata", "all_lesions.conf_99.txt", package = "maftools")
amp.genes <- system.file("extdata", "amp_genes.conf_99.txt", package = "maftools")
del.genes <- system.file("extdata", "del_genes.conf_99.txt", package = "maftools")
scores.gistic <- system.file("extdata", "scores.gistic", package = "maftools")
laml.gistic = readGistic(gisticAllLesionsFile = all.lesions, gisticAmpGenesFile = amp.genes, gisticDelGenesFile = del.genes, gisticScoresFile = scores.gistic)
write.GisticSummary(gistic = laml.gistic, basename = 'laml')

}
\seealso{
\code{\link{readGistic}}
}
