% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/AllslotAccessors.R
\docType{methods}
\name{MarrPSamplepairs}
\alias{MarrPSamplepairs}
\alias{MarrPSamplepairs,Marr-method}
\title{Generic function that returns the Marr P Sample Pairs}
\usage{
MarrPSamplepairs(object)

\S4method{MarrPSamplepairs}{Marr}(object)
}
\arguments{
\item{object}{an object of class \code{Marr}.}
}
\value{
Value of \code{pSamplepairs} argument passed 
to \code{Marr}
}
\description{
Given a Marr object, this function returns the
Marr P Sample Pairs

Accessors for the 'MarrPSamplepairs'
slot of a Marr object.
}
\examples{
data <- matrix(rnorm(2400), nrow=200, ncol=12)
data_Marr <- Marr(object = data, pSamplepairs=0.75,
                  pFeatures=0.75, alpha=0.05)
MarrPSamplepairs(data_Marr)

}
