% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mzGroup.R
\name{mzGroup}
\alias{mzGroup}
\title{Binning of mass spectral features in m/z dimension}
\usage{
mzGroup(xset, yset, binGap)
}
\arguments{
\item{xset}{data frame containing metabolomics features}

\item{yset}{data frame containing metabolomics features}

\item{binGap}{numeric gap value between consecutive sorted & pooled feature
m/z values.}
}
\value{
list object containing updated xset & yset with group information
}
\description{
Features in two input feature lists are grouped by their m/z values.
}
\details{
The m/z values from both datasets are pooled, sorted, and binned by the
\code{binGap} argument. Feature groups form when there is at least one pair
of features from both datasets whose consecutive difference is less than
\code{binGap}. Grouped features are joined together in \code{combinedTable}
data report.
}
