% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methInheritSim.R
\docType{data}
\name{dataSimExample}
\alias{dataSimExample}
\title{A \code{list} containing methylation information used by some internal 
functions (for demo purpose.}
\format{a \code{list} containing:
\itemize{
\item \code{stateInfo} a \code{GRanges}, a synthetic chromosome as 
generated by \code{getSyntheticChr} function. 
\item \code{stateDiff} a \code{list} containing:
\itemize{
\item \code{stateDiff} a \code{vector} of \code{integer} (\code{0} 
and \code{1}) with length corresponding the length of \code{stateInfo}.
The \code{vector}
indicates, using \code{1}, the positions where the CpG sites are
differentially methylated.
\item \code{stateInherite} a \code{vector} of \code{integer} (\code{0} and 
\code{1}) with length corresponding the length of \code{stateInfo}. The 
\code{vector}
indicates, using \code{1}, the positions where the CpG values are
inherited.
}
\item \code{treatment} a \code{vector} of \code{integer} (\code{0} 
and \code{1}) with length corresponding the number of samples. The 
\code{vector} indicates which samples are control (0) which samples are 
case (1).
\item \code{sample.id} a \code{list} of 3 \code{list}. Each entry of the
\code{list} correspond to one generation (first entry = first generation, 
etc..). Each  
\code{list} contains a \code{list} of 12 entries each containing a string
of \code{character}, the name of the sample. 
}}
\usage{
data(dataSimExample)
}
\value{
a \code{list} containing:
\itemize{
\item \code{stateInfo} a \code{GRanges}, a synthetic chromosome as 
generated by \code{getSyntheticChr} function. 
\item \code{stateDiff} a \code{list} containing:
\itemize{
\item \code{stateDiff} a \code{vector} of \code{integer} (\code{0} 
and \code{1}) with length corresponding the length of \code{stateInfo}.
The \code{vector}
indicates, using \code{1}, the positions where the CpG sites are
differentially methylated.
\item \code{stateInherite} a \code{vector} of \code{integer} (\code{0} and 
\code{1})
with length corresponding the length of \code{stateInfo}. The 
\code{vector}
indicates, using \code{1}, the positions where the CpG values are
inherited.
}
\item \code{treatment} a \code{vector} of \code{integer} (\code{0} 
and \code{1}) with length corresponding the number of samples. The 
\code{vector} indicates which samples are control (0) which samples are 
case (1).
\item \code{sample.id} a \code{list} of 3 \code{list}. Each entry of the
\code{list} correspond to one generation (first entry = first generation, 
etc..). Each  
\code{list} contains a \code{list} of 12 entries each containing a string
of \code{character}, the name of the sample.
}
}
\description{
A \code{list} containing methylation information used by some internal 
functions (for demo purpose.
}
\examples{

## Loading dataset
data(dataSimExample)

## Identify differentially methylated sites and among those, the ones
## that are inherited
methInheritSim:::getDiffMeth(stateInfo = dataSimExample$stateInfo, 
    rateDiff = 0.2, minRate = 0.3,propInherite = 0.3)

}
\seealso{
\itemize{
\item \code{\link{runSim}} {for running a
simulation analysis using methylKit info as input}
}
}
\keyword{datasets}
