% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methylInheritanceSimInternalMethods.R
\name{getSim}
\alias{getSim}
\title{Simulate the proportion of C/T at each site of synthetic CHR for 
each control and case}
\usage{
getSim(nbCtrl, nbCase, generation, stateInfo, stateDiff, stateInherite,
  diffValue, propDiff, propDiffsd, propInheritance, propHetero)
}
\arguments{
\item{nbCtrl}{a positive \code{integer}, the number of controls.}

\item{nbCase}{a positive \code{integer}, the number of cases.}

\item{generation}{a positive \code{integer}, the number of generations.}

\item{stateInfo}{a \code{GRanges} object, the synthetic chromosome 
generated by \code{getSyntheticChr} function.}

\item{stateDiff}{a \code{vector} of \code{integer} (\code{0} 
and \code{1}) with length corresponding the length of \code{stateInfo}.
The \code{vector} indicates, using a \code{1}, the positions where the CpG 
sites are differentially methylated.}

\item{stateInherite}{a \code{vector} of \code{integer} (\code{0} and 
\code{1}) with length corresponding the length of \code{stateInfo}. The 
\code{vector} indicates, using a \code{1}, the positions where the CpG 
values are inherited.}

\item{diffValue}{a non-negative \code{double} between between [0,1], the 
proportion of C/T for a case differentially methylated following a 
beta distribution 
where the mean is shifted of \code{diffValue} from the CTRL distribution.}

\item{propDiff}{a \code{double} superior to \code{0} and inferior or equal 
to \code{1}, the mean value for the proportion of samples that will have,
for a specific position, differentially methylated values. It can be 
interpreted as the penetrance.}

\item{propDiffsd}{a non-negative \code{double}, the standard deviation 
associated to the \code{propDiff}.}

\item{propInheritance}{a non-negative \code{double} between [0,1], the 
proportion of case that inherite differentially methylated sites.}

\item{propHetero}{a non-negative \code{double} between [0,1], the 
reduction of \code{vDiff} for the second and following generations.}
}
\value{
a \code{GRangesList}, the object contains information about the 
simulation. The file have four metadata related to the real dataset:
\itemize{
\item meanDiff, the means of the shifted distribution.
\item meanCTRL, the means of the control distribution.
\item partitionCase, the number of cases simulated using the shifted 
distribution.
\item partitionCtrl, the number of cases simulated using the control 
distribution and a metadata for each cases and controls 
the proportion of C/T.
}
}
\description{
For each control and case, generate the proportion of C/T at 
each of the synthetic CHR.
}
\examples{

## Fix seed to have reproducible results
set.seed(312)

## Load dataset
data("samplesForChrSynthetic")

## Generate a stateInfo object using samples
stateInformation <- methInheritSim:::getSyntheticChr(methInfo = 
    samplesForChrSynthetic, nbBlock = 1, nbCpG = 3)

## Generate a stateDiff and stateInherite objects with length corresponding 
## to nbBlock * nbCpG from stateInformation
stateDiff  <- c(1, 0, 1)
stateInherite <- c(1, 0, 0)

## Create a simulation using stateInformation, stateDiff and stateInherite
methInheritSim:::getSim(nbCtrl = 3, nbCase = 2, generation = 3, 
    stateInfo = stateInformation, stateDiff = stateDiff, 
    stateInherite = stateInherite, diffValue = 10, 
    propDiff = 0.8, propDiffsd = 0.2, propInheritance = 0.8, 
    propHetero = 0.1)

}
\author{
Pascal Belleau, Astrid Deschenes
}
\keyword{internal}
