% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methyLImp2.R
\name{split_by_chromosomes}
\alias{split_by_chromosomes}
\title{Split methylation dataset into a list by chromosomes}
\usage{
split_by_chromosomes(data, type = c("450K", "EPIC", "user"), annotation = NULL)
}
\arguments{
\item{data}{a numeric data matrix with with samples in rows and 
variables (probes) in named columns.}

\item{type}{a type of data, 450K or EPIC. Type is used to split CpGs across 
chromosomes. Match of CpGs to chromosomes is taken from ChAMPdata package. 
If you wish to provide your own match, specify "user" in 
this argument and provide a data frame in the next argument.}

\item{annotation}{a data frame, user provided match between CpG sites and 
chromosomes. Must contain two columns: cpg and chr. Choose "user" in the 
previous argument to be able to provide user annotation.}
}
\value{
A list of numeric data matrices where each matrix contains probes 
from one chromosome.
}
\description{
This function split a given methylation dataset into a list of datasets according to a given annotation.
}
