% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffMethDSS.R
\docType{methods}
\name{calculateDiffMethDSS}
\alias{calculateDiffMethDSS}
\alias{calculateDiffMethDSS,methylBase-method}
\title{calculate Differential Methylation with DSS}
\usage{
calculateDiffMethDSS(
  meth,
  adjust = c("SLIM", "holm", "hochberg", "hommel", "bonferroni", "BH", "BY", "fdr",
    "none", "qvalue"),
  mc.cores = 1
)

\S4method{calculateDiffMethDSS}{methylBase}(
  meth,
  adjust = c("SLIM", "holm", "hochberg", "hommel", "bonferroni", "BH", "BY", "fdr",
    "none", "qvalue"),
  mc.cores = 1
)
}
\arguments{
\item{meth}{a methylBase object}

\item{adjust}{different methods to correct the p-values for multiple testing. 
Default is "SLIM" from methylKit. For "qvalue" please see 
\code{\link[qvalue]{qvalue}} 
and for all other methods see \code{\link[stats]{p.adjust}}.}

\item{mc.cores}{integer denoting how many cores should be used for parallel
differential methylation calculations (can only be used in
machines with multiple cores).}
}
\value{
a methylDiff object
}
\description{
This function provides an interface to the  beta-binomial model from DSS
package by Hao Wu. It calculates the differential methylation statistics
using a beta-binomial model with parameter shrinkage. See the reference
for details.
}
\examples{

data(methylKit)

dssDiffay <- calculateDiffMethDSS(methylBase.obj, adjust="SLIM", mc.cores=1)

}
\references{
Feng H, Conneely K and Wu H (2014). A bayesian hierarchical model to 
detect differentially
 methylated loci from single nucleotide resolution sequencing 
 data. Nucleic acids research
}
