% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backbone.R, R/methylDBFunctions.R
\docType{methods}
\name{getCoverageStats}
\alias{getCoverageStats}
\alias{getCoverageStats,methylRaw-method}
\alias{getCoverageStats,methylRawDB-method}
\title{get coverage stats from methylRaw object}
\usage{
getCoverageStats(
  object,
  plot = FALSE,
  both.strands = FALSE,
  labels = TRUE,
  ...,
  chunk.size = 1e+06
)

\S4method{getCoverageStats}{methylRaw}(
  object,
  plot = FALSE,
  both.strands = FALSE,
  labels = TRUE,
  ...,
  chunk.size = 1e+06
)

\S4method{getCoverageStats}{methylRawDB}(
  object,
  plot = FALSE,
  both.strands = FALSE,
  labels = TRUE,
  ...,
  chunk.size = 1e+06
)
}
\arguments{
\item{object}{a \code{methylRaw} or \code{methylRawDB} object}

\item{plot}{plot a histogram of coverage if TRUE (default:FALSE)}

\item{both.strands}{do stats and plot for both strands if TRUE 
(default:FALSE)}

\item{labels}{should the bars of the histrogram have labels showing 
the percentage of values in each bin (default:TRUE)}

\item{...}{options to be passed to \code{\link[graphics]{hist}} function}

\item{chunk.size}{Number of rows to be taken as a chunk for processing the 
\code{methylRawDB} objects (default: 1e6)}
}
\value{
a summary of coverage statistics or plot a histogram of coverage
}
\description{
The function returns basic statistics about read coverage per base. 
It can also plot a histogram of read coverage values.
}
\section{Details}{

The parameter \code{chunk.size} is only used when working with
 \code{methylRawDB} or \code{methylRawListDB} objects, 
as they are read in chunk by chunk to enable processing large-sized objects
 which are stored as flat file database.
Per default the chunk.size is set to 1M rows, which should work for most 
systems. If you encounter memory problems or 
have a high amount of memory available feel free to adjust the 
\code{chunk.size}.
}

\examples{
data(methylKit)

# gets coverage stats for the first sample in methylRawList.obj object
getCoverageStats(methylRawList.obj[[1]],plot=TRUE,
both.strands=FALSE,labels=TRUE)

}
