% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methylDBClasses.R
\docType{methods}
\name{getDBPath}
\alias{getDBPath}
\alias{getDBPath,methylRawListDB-method}
\alias{getDBPath,methylBaseDB-method}
\alias{getDBPath,methylRawDB-method}
\alias{getDBPath,methylDiffDB-method}
\title{Get path to database of the methylDB objects}
\usage{
getDBPath(x)

\S4method{getDBPath}{methylRawListDB}(x)

\S4method{getDBPath}{methylBaseDB}(x)

\S4method{getDBPath}{methylRawDB}(x)

\S4method{getDBPath}{methylDiffDB}(x)
}
\arguments{
\item{x}{an \code{\link{methylBaseDB}},\code{\link{methylRawDB}},
\code{\link{methylRawListDB}} or \code{\link{methylDiffDB}} object}
}
\description{
The function returns the path to the flat file database that stores the data 
of the \code{\link{methylRawDB}}, 
\code{\link{methylRawListDB}}, \code{\link{methylBaseDB}} or 
\code{\link{methylDiffDB}} objects.
}
\examples{

data(methylKit)

methylBaseDB.obj <- unite(methylRawList.obj,save.db=TRUE,dbdir="methylDB")


#The path to the database is returned
getDBPath(methylBaseDB.obj)


# remove Database again
rm(methylBaseDB.obj)
unlink("methylDB",recursive=TRUE)

}
