% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methylDBClasses.R
\docType{class}
\name{methylRawDB-class}
\alias{methylRawDB-class}
\alias{methylRawDB}
\title{An S4 class for storing raw methylation data as flat file database.}
\description{
This object stores the raw mehylation data that is read in through read 
function as flat file database.The raw methylation data is basically
percent methylation values and read coverage values per genomic base/region.
}
\section{Slots}{
\describe{
 \item{\code{dbpath}:}{path to flat file database }
 \item{\code{num.records}:}{number of records (lines) in the object}
 \item{\code{sample.id}:}{string for an identifier of the sample}
 \item{\code{assembly}:}{string for genome assembly, ex: hg18,hg19,mm9}
 \item{\code{context}:}{ methylation context string, ex: CpG,CpH,CHH, etc.}
 \item{\code{resolution}:}{ resolution of methylation information, 'base' or 
 'region'}
 \item{\code{dbtype}:}{string for type of the flat file database, ex: tabix}
                }
}

\section{Details}{

\code{methylRawDB} is created via \code{\link{read}} function and has the 
same functionality as \code{\link{methylRaw}} class, 
but the data is saved in a flat database file and therefore allocates less 
space in memory.
}

\section{Subsetting}{

 In the following code snippets, \code{x} is a \code{methylRawDB}.
 Subsetting by \code{x[i,]} will produce a new \code{methylRaw} object if 
 subsetting is done on
 rows. Column subsetting is not directly allowed to prevent errors in the 
 downstream analysis. see ?methylKit[ .
 \code{x[]} will return the \code{methylRawDB} object as new \code{methylRaw} object
}

\section{Accessors}{
 
The following functions provides access to data slots of methylDiffDB:
- \code{\link{getData}}: get the data slot from the methylKit objects,
- \code{\link{getAssembly}}: get assembly of the genome,
- \code{\link{getContext}}: get the context of methylation
}

\section{Coercion}{

  \code{methylRawDB} object can be coerced to:
  \code{\link[GenomicRanges:GRanges-class]{GRanges}} object via \code{\link{as}} function.
  \code{\link{methylRaw}} object via \code{\link{as}} function.
}

\examples{

# example of a raw methylation data contained as a text file
read.table(system.file("extdata", "control1.myCpG.txt", package = "methylKit"),
header=TRUE,nrows=5)


methylRawDB.obj <- methRead(
system.file("extdata", "control1.myCpG.txt", package = "methylKit"),
                        sample.id = "ctrl1", assembly = "hg18",
                        dbtype = "tabix", dbdir = "methylDB")

# example of a methylRawDB object
methylRawDB.obj
str(methylRawDB.obj)

library(GenomicRanges)

#coercing methylRawDB object to GRanges object
my.gr=as(methylRawDB.obj,"GRanges")

#coercing methylRawDB object to methylRaw object
myRaw=as(methylRawDB.obj,"methylRaw")

# remove Database again
rm(methylRawDB.obj)
unlink("methylDB",recursive=TRUE)

}
