% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backbone.R, R/diffMeth.R, R/methylDBClasses.R
\docType{methods}
\name{selectByOverlap}
\alias{selectByOverlap}
\alias{selectByOverlap,methylRaw,GRanges-method}
\alias{selectByOverlap,methylRaw-method}
\alias{selectByOverlap,methylRawList,GRanges-method}
\alias{selectByOverlap,methylRawList-method}
\alias{selectByOverlap,methylBase,GRanges-method}
\alias{selectByOverlap,methylBase-method}
\alias{selectByOverlap,methylDiff,GRanges-method}
\alias{selectByOverlap,methylDiff-method}
\alias{selectByOverlap,methylRawDB,GRanges-method}
\alias{selectByOverlap,methylRawDB-method}
\alias{selectByOverlap,methylRawListDB,GRanges-method}
\alias{selectByOverlap,methylRawListDB-method}
\alias{selectByOverlap,methylBaseDB,GRanges-method}
\alias{selectByOverlap,methylBaseDB-method}
\alias{selectByOverlap,methylDiffDB,GRanges-method}
\alias{selectByOverlap,methylDiffDB-method}
\title{selects records of methylDB objects lying inside a GRanges range}
\usage{
selectByOverlap(object,ranges)

\S4method{selectByOverlap}{methylRaw,GRanges}(object, ranges)

\S4method{selectByOverlap}{methylRawList,GRanges}(object, ranges)

\S4method{selectByOverlap}{methylBase,GRanges}(object, ranges)

\S4method{selectByOverlap}{methylDiff,GRanges}(object, ranges)

\S4method{selectByOverlap}{methylRawDB,GRanges}(object, ranges)

\S4method{selectByOverlap}{methylRawListDB,GRanges}(object, ranges)

\S4method{selectByOverlap}{methylBaseDB,GRanges}(object, ranges)

\S4method{selectByOverlap}{methylDiffDB,GRanges}(object, ranges)
}
\arguments{
\item{object}{an \code{\link{methylRaw}},\code{\link{methylRawDB}}, 
\code{\link{methylRawList}}, \code{\link{methylRawListDB}},
\code{\link{methylBase}}, \code{\link{methylBaseDB}}, 
\code{\link{methylDiff}} or \code{\link{methylDiffDB}} object}

\item{ranges}{a GRanges object specifying the regions of interest}
}
\value{
a \code{\link{methylBase}},\code{\link{methylRaw}}, 
\code{\link{methylRawList}} or \code{\link{methylDiff}} object 
depending on the input object.
}
\description{
The function selects records from any \code{methylKit} object that lie
inside the regions given by \code{ranges} of class \code{\link{GRanges}} and returns
an in-memory equivalent of this object
}
\examples{
data(methylKit)

file.list=list( system.file("extdata", "test1.myCpG.txt", package = "methylKit"),
                system.file("extdata", "test2.myCpG.txt", package = "methylKit"),
                system.file("extdata", "control1.myCpG.txt", package = "methylKit"),
                system.file("extdata", "control2.myCpG.txt", package = "methylKit") )

methylRawListDB.obj=methRead(file.list,
                         sample.id=list("test1","test2","ctrl1","ctrl2"),
                         assembly="hg18",treatment=c(1,1,0,0),
                         dbtype = "tabix",dbdir = "methylDB")

methylBaseDB.obj=unite(methylRawListDB.obj)

methylDiffDB.obj = calculateDiffMeth(methylBaseDB.obj)

# define the windows of interest as a GRanges object, this can be any set 
# of genomic locations
library(GenomicRanges)
my.win=GRanges(seqnames="chr21",
ranges=IRanges(start=seq(from=9764513,by=10000,length.out=20),width=5000) )

# selects the records that lie inside the regions
myRaw <- selectByOverlap(methylRawListDB.obj[[1]],my.win)

# selects the records that lie inside the regions
myBase <- selectByOverlap(methylBaseDB.obj,my.win)

# selects the records that lie inside the regions
myDiff <- selectByOverlap(methylDiffDB.obj,my.win)

# selects the records that lie inside the regions
myRaw2 <- selectByOverlap(methylRawList.obj[[1]],my.win)

# selects the records that lie inside the regions
myRawList2 <- selectByOverlap(methylRawList.obj,my.win)

# selects the records that lie inside the regions
myBase2 <- selectByOverlap(methylBase.obj,my.win)

# selects the records that lie inside the regions
myDiff2 <- selectByOverlap(methylDiff.obj,my.win)


rm(methylRawListDB.obj)
rm(methylBaseDB.obj)
rm(methylDiffDB.obj)
unlink("methylDB",recursive=TRUE)

}
\author{
Alexander Gosdschan
}
