% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miRNAtap.R
\name{aggregateRanks}
\alias{aggregateRanks}
\title{Aggreagate ranks from multiple sources with various methods}
\usage{
aggregateRanks(ranks, n_valid_srcs, min_src, method = "geom",
  promote = TRUE)
}
\arguments{
\item{ranks}{\code{data.frame} with ordered scores}

\item{n_valid_srcs}{number of valid sources in the dataset}

\item{min_src}{minimum acceptable number fo sources}

\item{method}{\code{'min'},\code{'max'}, or \code{'geom'},
default \code{'geom'}}

\item{promote}{add weights to improve accuracy of the method, default 
\code{TRUE}}
}
\value{
\code{data.frame} object with ranks per source and aggregate ranks
}
\description{
This function performs aggregation phase of target 
prediction for \code{\link{getPredictedTargets}}. 
Consensus ranking is derived from multiple individual rankings. 
Available methods include minimum, maximum and geometric mean with further 
tuning parameters which promote true positives at the top of the final 
ranking
}
\examples{
data = data.frame(GeneID=c("15364", "56520", "57781", "58180", "18035"),
                source1scores=c(0.9,0.5,0.3,NA,NA),
                source2scores=c(0.7,NA,0.8,0.6,0.5),
                source3scores=c(0.5,NA,0.3,0.1,0.2))
data #dataframe with scores
aggregateRanks(data, n_valid_srcs=3, min_src=2, method='geom')
#note how gene 56520 is eliminated as it appeared in fewer than 2 sources
}
\author{
Maciej Pajak \email{m.pajak@sms.ed.ac.uk}
}

