% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miRNAtap.R
\name{getPredictedTargets}
\alias{getPredictedTargets}
\title{Get aggregated ordered list of predicted targets for miRNA}
\usage{
getPredictedTargets(mirna, sources = c("pictar", "diana", 
"targetscan", "miranda","mirdb"), species = "mmu", min_src = 2, 
method = "geom", promote = TRUE, synonyms = TRUE, both_strands = FALSE, ...)
}
\arguments{
\item{mirna}{miRNA in a standard format}

\item{sources}{a list of sources to use for aggregation, 
default is all five sources, i.e. 
\code{c('pictar','diana','targetscan','miranda','mirdb')}}

\item{species}{species in a standard three-letter acronym, \code{'mmu'} 
and \code{'hsa'} 
available as direct targets, \code{'rno'} as homology translations, 
default \code{'mmu'}}

\item{min_src}{minimum number of sources required for a target to be 
considered, default 2}

\item{method}{method of aggregation - choose from \code{'min'}, 
\code{'max'}, and \code{'geom'}; 
\code{'min'} is a minimum of ranks, \code{'max'} is a maximum of ranks,
and default \code{'geom'} 
is based on geometric mean of the ranks which proves to be the most 
accurate method.}

\item{promote}{add weights to improve accuracy of the method, default TRUE}

\item{synonyms}{when searching for -3p miRNA automatically also searches for
miRNA with the same name but ending with * (some databases list -3p miRNA
this way) and other way around, similarly for -5p miRNA, default TRUE}

\item{both_strands}{overrides \code{synonyms} and searches for targets of
both -5p and -3p strands together}

\item{...}{any optional arguments}
}
\value{
\code{data.frame} object where row names are entrez IDs of target
genes, ranks from individual sources and aggregated rank are shown 
in columns.
If no targets are found in any of the sources \code{NULL} and a warning
are returned.
}
\description{
This method performs aggregation of target lists from multiple 
sources. Aggregated list is more accurate than any list from a single 
source. Multiple aggregation methods are available.Direct target data from 
five sources for Human and Mouse is supplied through \code{miRNAtap.db} 
package, for Rat targets are derived through homology translations whenever 
direct ones are not available.
}
\details{
Tuning \code{min_src} parameter is an easy way of prioritising 
precision at the top of the list (high values) or total recall (low values).
For the five default input sources, recommended values are 2, 3, or 4.
}
\examples{
targets <- getPredictedTargets('let-7a',species='hsa', method = 'min') 
head(targets) #top of the list with minimum aggregation
targets2 <- getPredictedTargets('let-7a',species='hsa', method='geom') 
head(targets2) #top of the list with geometric mean aggregation
}
\author{
Maciej Pajak \email{m.pajak@sms.ed.ac.uk}
}
\references{
Agarwal V, Bell GW, Nam J, Bartel DP. Predicting effective microRNA 
target sites in mammalian mRNAs. eLife, 4:e05005, (2015).

Griffiths-Jones, S., Saini, H. K., van Dongen, S., and Enright, A. J. 
(2008). miRBase: tools for microRNA genomics. Nucleic acids research, 
36(Database issue):D154-8.

Lall, S., Grun, D., Krek, A., Chen, K., Wang, Y.-L., Dewey, C. N., ... 
Rajewsky, N. (2006). A genome-wide map of conserved microRNA targets in 
C. elegans. Current biology : CB, 16(5):460-71.

Paraskevopoulou MD, Georgakilas G, Kostoulas N, Vlachos IS, Vergoulis 
T, Reczko M, Filippidis C, Dalamagas T, Hatzigeorgiou AG., 
"DIANA-microT web server v5.0: service integration into miRNA 
functional analysis workflows.", Nucleic Acids Res. 2013 
Jul;41(Web Server issue):W169-73.

Wong N and Wang X (2015) miRDB: an online resource for microRNA 
target prediction and functional annotations. Nucleic Acids Research. 
43(D1):D146-152.
}

