% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{.simulationTimes}
\alias{.simulationTimes}
\title{Generate simulation times and the indices of time points to return
in simulation functions.}
\usage{
.simulationTimes(t_start = 0, t_end = 1000, t_step = 0.1, t_store = 1000)
}
\arguments{
\item{t_start}{\code{Numeric scalar}. Indicates the initial time of the simulation.
(Default: \code{0})}

\item{t_end}{\code{Numeric scalar}. Indicates the final time of the simulation
(Default: \code{1000})}

\item{t_step}{\code{Numeric scalar}. Indicates the interval between simulation steps
(Default: \code{0.1})}

\item{t_store}{\code{Integer scalar}. Indicates the number of evenly distributed
time points to keep (Default: \code{100})}
}
\value{
lists containing simulation times (t_sys) and the indices to keep.
}
\description{
Generate simulation times and the indices of time points to return
in simulation functions.
}
\examples{
Time <- .simulationTimes(
    t_start = 0, t_end = 100, t_step = 0.5,
    t_store = 100
)
DefaultTime <- .simulationTimes(t_end = 1000)

}
\keyword{internal}
