% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertFromDADA2.R
\name{convertFromDADA2}
\alias{convertFromDADA2}
\title{Create a \code{TreeSummarizedExperiment} object from \sQuote{DADA2} results}
\usage{
convertFromDADA2(...)
}
\arguments{
\item{...}{Additional arguments. For \code{convertFromDADA2}, see
\code{mergePairs} function for more details.}
}
\value{
\code{convertFromDADA2} returns an object of class
\code{\link[TreeSummarizedExperiment:TreeSummarizedExperiment-class]{TreeSummarizedExperiment}}
}
\description{
Create a \code{TreeSummarizedExperiment} object from \sQuote{DADA2} results
}
\details{
\code{convertFromDADA2} is a wrapper for the
\code{mergePairs} function from the \code{dada2} package.
A count matrix is constructed via
\code{makeSequenceTable(mergePairs(...))} and rownames are dynamically
created as \code{ASV(N)} with \code{N} from 1 to \code{nrow} of the count
tables. The colnames and rownames from the output of \code{makeSequenceTable}
are stored as \code{colnames} and in the \code{referenceSeq} slot of the
\code{TreeSummarizedExperiment}, respectively.
}
\examples{

### Coerce DADA2 results to a TreeSE object
if(requireNamespace("dada2")) {
  fnF <- system.file("extdata", "sam1F.fastq.gz", package="dada2")
  fnR = system.file("extdata", "sam1R.fastq.gz", package="dada2")
  dadaF <- dada2::dada(fnF, selfConsist=TRUE)
  dadaR <- dada2::dada(fnR, selfConsist=TRUE)

  tse <- convertFromDADA2(dadaF, fnF, dadaR, fnR)
  tse
}
}
