% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/getAbundant.R
\name{getAbundant}
\alias{getAbundant}
\alias{getLowAbundant}
\alias{getConditionallyLowAbundant}
\alias{getPermanentlyLowAbundant}
\alias{getAbundanceClass}
\alias{addAbundanceClass}
\alias{getAbundant,SingleCellExperiment-method}
\alias{getAbundant,SummarizedExperiment-method}
\alias{getAbundant,ANY-method}
\alias{getLowAbundant,SingleCellExperiment-method}
\alias{getLowAbundant,SummarizedExperiment-method}
\alias{getLowAbundant,ANY-method}
\alias{getConditionallyLowAbundant,SingleCellExperiment-method}
\alias{getConditionallyLowAbundant,SummarizedExperiment-method}
\alias{getConditionallyLowAbundant,ANY-method}
\alias{getPermanentlyLowAbundant,SingleCellExperiment-method}
\alias{getPermanentlyLowAbundant,SummarizedExperiment-method}
\alias{getPermanentlyLowAbundant,ANY-method}
\alias{getAbundanceClass,SingleCellExperiment-method}
\alias{getAbundanceClass,SummarizedExperiment-method}
\alias{getAbundanceClass,ANY-method}
\alias{addAbundanceClass,SingleCellExperiment-method}
\alias{addAbundanceClass,SummarizedExperiment-method}
\title{Determine abundant and rare taxa. Rare taxa can be further classified
to conditionally rare and permanently rare.}
\usage{
getAbundant(x, ...)

getLowAbundant(x, ...)

getConditionallyLowAbundant(x, ...)

getPermanentlyLowAbundant(x, ...)

getAbundanceClass(x, ...)

addAbundanceClass(x, ...)

\S4method{getAbundant}{SingleCellExperiment}(x, ...)

\S4method{getAbundant}{SummarizedExperiment}(x, assay.type = "relabundance", ...)

\S4method{getAbundant}{ANY}(x, abundant.th = 1/100, ...)

\S4method{getLowAbundant}{SingleCellExperiment}(x, ...)

\S4method{getLowAbundant}{SummarizedExperiment}(x, assay.type = "relabundance", abundant.th = 1/100, ...)

\S4method{getLowAbundant}{ANY}(x, abundant.th = 1/100, ...)

\S4method{getConditionallyLowAbundant}{SingleCellExperiment}(x, ...)

\S4method{getConditionallyLowAbundant}{SummarizedExperiment}(x, assay.type = "relabundance", ...)

\S4method{getConditionallyLowAbundant}{ANY}(x, abundant.th = 1/100, crt.th = 100, ...)

\S4method{getPermanentlyLowAbundant}{SingleCellExperiment}(x, ...)

\S4method{getPermanentlyLowAbundant}{SummarizedExperiment}(x, assay.type = "relabundance", ...)

\S4method{getPermanentlyLowAbundant}{ANY}(x, abundant.th = 1/100, prt.th = 5, ...)

\S4method{getAbundanceClass}{SingleCellExperiment}(x, ...)

\S4method{getAbundanceClass}{SummarizedExperiment}(x, assay.type = "relabundance", ...)

\S4method{getAbundanceClass}{ANY}(x, abundant.th = 1/100, crt.th = 100, prt.th = 5, ...)

\S4method{addAbundanceClass}{SingleCellExperiment}(x, ...)

\S4method{addAbundanceClass}{SummarizedExperiment}(x, name = "abundance_class", ...)
}
\arguments{
\item{x}{a \code{\link[SummarizedExperiment]{SummarizedExperiment}} object.}

\item{...}{additional arguments.}

\item{assay.type}{\code{Character scalar}. Specifies the name of assay
used in calculation. (Default: \code{"relabundance"})}

\item{abundant.th}{\code{Numeric scalar}. Specifies threshold that is used
to separate abundant features from rare. (Default: \code{1/100})}

\item{crt.th}{\code{Numeric scalar}. Specifies threshold that is used
to separate conditionally rare features from other rare features.
(Default: \code{100})}

\item{prt.th}{\code{Numeric scalar}. Specifies threshold that is used
to separate permanently rare features from other rare features.
(Default: \code{5})}

\item{name}{\code{Character scalar}. Specifies name of column in
\code{rowData} where the results will be stored.
(Default: \code{"abundance_class"})}
}
\value{
For \code{getAbundant}, \code{getLowAbundant},
\code{getConditionallyLowAbundant}, and \code{getPermanentlyLowAbundant} a
\code{vector} of taxa. For \code{getAbudanceClass} a vector of abundance
classes for each feature. For \code{addAbudanceClass}, a
\code{SummarizedExperiment} object.
}
\description{
These functions determine abundant and rare taxa based on the abundances
of taxa. Compared to \code{\link[=getPrevalence]{getPrevalent}} and
\code{\link[=getPrevalence]{getRare}}, these functions determine abundant
and rare taxa based on abundance while the first mentioned are based on
prevalence.
}
\details{
These functions identify abundant and rare taxa in a dataset.
Abundant taxa are characterized by high average abundance across the dataset,
while rare taxa are characterized by consistently low abundance.

Conditionally rare taxa exhibit variable abundance, being abundant in some
samples and rare in others. In contrast, permanently rare taxa consistently
maintain low abundance across all samples.

\itemize{
\item Abundant taxa: Taxa with an average abundance exceeding
\code{abundant.th}.

\item Low abundant / rare taxa: Taxa with an average abundance not
exceeding \code{abundant.th}. Optionally, if specified, they must also
satisfy the condition \eqn{crt.th >=
  \frac{abundance_{max}}{abundance_{min}} > prt.th}.

\item Conditionally rare or low abundant taxa (CRT): Taxa with an average
abundance not exceeding \code{abundant.th} and with a maximum-to-minimum
abundance ratio (\eqn{\frac{abundance_{max}}{abundance_{min}}}) greater
than \code{crt.th}.

\item Permanently rare or low abundant taxa (PRT): Taxa with an average
abundance not exceeding \code{abundant.th} and with a maximum-to-minimum
abundance ratio (\eqn{\frac{abundance_{max}}{abundance_{min}}}) less than
or equal to \code{prt.th}.
}
}
\examples{

data(GlobalPatterns)
tse <- GlobalPatterns

# Agglomerate to family level
tse <- agglomerateByRank(tse, rank = "Family")
# Transform to relative abundances. Note that we add pseudocount. This is
# because otherwise we cannot calculate CRT and PRT due to zeroes and
# zero division in calculating abundance ratio.
tse <- transformAssay(tse, method = "relabundance", pseudocount = TRUE)

# Get abundant taxa
abundant <- getAbundant(tse, assay.type = "relabundance")
abundant |> head()

# Get all rare taxa that have average relative abundance below 10\%
rare <- getLowAbundant(
    tse, assay.type = "relabundance", abundant.th = 10/100)
rare |> head()

# Get rare taxa that are not permanently or conditionally rare
rare <- getLowAbundant(
    tse, assay.type = "relabundance", prt.th = 5, crt.th = 100)
rare |> head()

# Get permanently rare taxa
prt <- getPermanentlyLowAbundant(
    tse, assay.type = "relabundance", prt.th = 5)
prt |> head()

# Get conditionally rare taxa
prt <- getConditionallyLowAbundant(
    tse, assay.type = "relabundance", crt.th = 100)
prt |> head()

# To classify all features, one can use *AbundantClass function
tse <- addAbundanceClass(tse)
# When one uses add* function, the results are stored to rowData
rowData(tse)

}
\references{
Sizhong Y. et al. (2017) Community structure of rare methanogenic archaea:
insight from a single functional group- \emph{FEMS Microbiol. Ecol.} 93(11).
\url{https://doi.org/10.1093/femsec/fix126}
}
\seealso{
\code{\link[=getPrevalence]{getPrevalent}} and
\code{\link[=getPrevalence]{getRare}}
}
