% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inter_functions.R
\name{calculatePCAs}
\alias{calculatePCAs}
\title{Function to compute the PCAs for a given distance matrix}
\usage{
calculatePCAs(distmat, pcas)
}
\arguments{
\item{distmat}{the distance matrix}

\item{pcas}{2-element vector of PCAs to include in results}
}
\value{
the x slot limited to pcas after calling stats::prcomp on distmat
}
\description{
Function to compute the PCAs for a given distance matrix
}
\examples{
data("mouseData", package = "metagenomeSeq")
aggdat <- aggFeatures(mouseData, level = "genus")
distmat <- computeDistMat(aggdat, dist_method = "bray")
calculatePCAs(distmat, c(1,2))

}
