% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intra_functions.R
\name{plotAlpha}
\alias{plotAlpha}
\title{Plot alpha diversity}
\usage{
plotAlpha(
  aggdat,
  level,
  index = c("shannon", "simpson", "invsimpson", "richness"),
  x_var = "SAMPLE_ID",
  ylab = index,
  col_by = NULL,
  facet1 = NULL,
  facet2 = NULL,
  plotTitle = "",
  pwidth = 500,
  pheight = 150
)
}
\arguments{
\item{aggdat}{aggregated MRExperiment}

\item{level}{Feature level}

\item{index}{Diversity index, one of "shannon", "simpson", "invsimpson" or 
"richness" (=number of features). Default is "shannon".}

\item{x_var}{Phenotype to aggregate over on X-axis. Default by "SAMPLE_ID".}

\item{ylab}{Y-axis label. Default is "Reads".}

\item{col_by}{Phenotype for coloring.}

\item{facet1}{Phenotype for facet 1.}

\item{facet2}{Phenotype for facet 2.}

\item{plotTitle}{Plot title. By default, no title is used.}

\item{pwidth}{overall plot width; default is 650}

\item{pheight}{overall plot height; default is 150}
}
\value{
plotly plot object
}
\description{
This function plots the alpha diversity. See ?vegan::diversity for details
on the available index
}
\examples{
data("mouseData", package = "metagenomeSeq")
aggdat <- aggFeatures(mouseData, level = "genus")
plotAlpha(aggdat, level = "genus", index = "shannon", x_var = "diet")

}
