% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/longitudinal_functions.R
\name{plotLongFeature}
\alias{plotLongFeature}
\title{Plot longitudinal features}
\usage{
plotLongFeature(
  aggdat,
  feature,
  x_var,
  id_var = "SAMPLE_ID",
  plotTitle = NULL,
  ylab = "Reads",
  log = FALSE,
  showLines = TRUE,
  fixedHeight = NULL,
  x_levels = NULL,
  pwidth = 650
)
}
\arguments{
\item{aggdat}{aggregated MRExperiment}

\item{feature}{Feature to plot.}

\item{x_var}{Phenotype to show along on X-axis.}

\item{id_var}{phenotype used to connect data points. Default is "SAMPLE_ID"}

\item{plotTitle}{Plot title. Default shows no title.}

\item{ylab}{Y-axis label. Default is "Reads"}

\item{log}{Log2 transform data. Default is FALSE.}

\item{showLines}{add lines between the points}

\item{fixedHeight}{sets a specific plot height (differential analysis)}

\item{x_levels}{restrict to specific levels of x_var (differential analysis)}

\item{pwidth}{overall plot width; default is 650}
}
\value{
plotly object holding long feature plot
}
\description{
This function plots the reads of a particular feature over different time points.
}
\examples{
data("mouseData", package = "metagenomeSeq")
aggdat <- aggFeatures(mouseData, level = "genus")
plotLongFeature(aggdat, feature = "Prevotella", x_var = "diet", 
                id_var = "mouseID")

}
\author{
Janina Reeder, Mo Huang
}
