% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intra_functions.R
\name{plotSingleFeature}
\alias{plotSingleFeature}
\title{Plot features}
\usage{
plotSingleFeature(
  aggdat,
  feature = "other",
  x_var = "SAMPLE_ID",
  ind = seq_len(10),
  plotTitle = NULL,
  ylab = "Reads",
  xlab = NULL,
  facet1 = NULL,
  facet2 = NULL,
  log = FALSE,
  showPoints = FALSE,
  fixedHeight = NULL,
  x_levels = NULL,
  pwidth = 500
)
}
\arguments{
\item{aggdat}{aggregated MRExperiment}

\item{feature}{Feature to plot.}

\item{x_var}{Phenotype to aggregate over on X-axis. Default by "SAMPLE_ID".}

\item{ind}{Indices of top abundant features to plot. Needed to determine 
appropriate color}

\item{plotTitle}{Plot title. Default shows no title.}

\item{ylab}{Y-axis label. Default is "Reads"}

\item{xlab}{X-axis label. If NULL, x_var will be used as label.}

\item{facet1}{Phenotype for facet 1.}

\item{facet2}{Phenotype for facet 2.}

\item{log}{Log2 transform data. Default is FALSE.}

\item{showPoints}{add points for each sample on plot}

\item{fixedHeight}{sets a specific plot height (differential analysis)}

\item{x_levels}{restrict to specific levels of x_var (differential analysis)}

\item{pwidth}{overall plot width; default is 650}
}
\value{
plotly plot object
}
\description{
This function plots the reads of a particular feature or set of features.
}
\examples{
data("mouseData", package = "metagenomeSeq")
aggdat <- aggFeatures(mouseData, level = "genus")
plotSingleFeature(aggdat, feature = "Prevotella", x_var = "diet")

}
\author{
Janina Reeder
}
