% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bimodality.R
\name{multimodality}
\alias{multimodality}
\title{Multimodality Score}
\usage{
multimodality(
  x,
  peak.threshold = 1,
  bw.adjust = 1,
  bs.iter = 100,
  min.density = 1,
  verbose = TRUE
)
}
\arguments{
\item{x}{A vector, or data matrix (variables x samples)}

\item{peak.threshold}{Mode detection threshold}

\item{bw.adjust}{Bandwidth adjustment}

\item{bs.iter}{Bootstrap iterations}

\item{min.density}{minimum accepted density for a maximum;
as a multiple of kernel height}

\item{verbose}{Verbose}
}
\value{
A list with following elements: 
\itemize{
\item{score}{Fraction of bootstrap samples with multiple
observed modes}
\item{nmodes}{The most frequently observed number of modes
in bootstrap}
\item{results}{Full results of potential_analysis for each
row of the input matrix.}
}
}
\description{
Multimodality score based on bootstrapped potential analysis.
}
\details{
Repeats potential analysis (Livina et al. 2010) multiple times
with bootstrap sampling for each row of the input data
(as in Lahti et al. 2014) and returns the specified results.
}
\examples{
#data(peerj32)
#s <- multimodality(t(peerj32$microbes[, c('Akkermansia', 'Dialister')]))
}
\references{
\itemize{
\item{}{Livina et al. (2010). Potential analysis reveals changing
number of climate states during the last 60 kyr.
\emph{Climate of the Past}, 6, 77-82.}
\item{}{Lahti et al. (2014). Tipping elements of the human intestinal
ecosystem. \emph{Nature Communications} 5:4344.}
}
}
\author{
Leo Lahti \email{leo.lahti@iki.fi}
}
\keyword{utilities}
