% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_taxa_prevalence.R
\name{plot_taxa_prevalence}
\alias{plot_taxa_prevalence}
\title{Visualize Prevalence Distributions for Taxa}
\usage{
plot_taxa_prevalence(x, level, detection = 0)
}
\arguments{
\item{x}{\code{\link{phyloseq-class}} object, OTU data must be counts and
not relative abundance or other transformed data.}

\item{level}{Phylum/Order/Class/Family}

\item{detection}{Detection threshold for presence (prevalance)}
}
\value{
A \code{\link{ggplot}} plot object.
}
\description{
Create taxa prevalence plots at various taxonomic levels.
}
\details{
This helps to obtain first insights into how is the taxa
distribution in the data. It also gives an idea about the taxonomic
affiliation of rare and abundant taxa in the data.
This may be helpful for data filtering or other downstream analysis.
}
\examples{
data(atlas1006)
# Pick data subset just to speed up example
p0 <- subset_samples(atlas1006, DNA_extraction_method == "r")
p0 <- prune_taxa(taxa(p0)[grep("Bacteroides", taxa(p0))], p0)
# Detection threshold (0 by default; higher especially with HITChip)
p <- plot_taxa_prevalence(p0, 'Phylum', detection = 1)
print(p)
}
\author{
Sudarshan A. Shetty \email{sudarshanshetty9@gmail.com}
}
\keyword{utilities}
