% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcNhoodDistance.R
\name{calcNhoodDistance}
\alias{calcNhoodDistance}
\title{Calculate within neighbourhood distances}
\usage{
calcNhoodDistance(x, d, reduced.dim = NULL, use.assay = "logcounts")
}
\arguments{
\item{x}{A \code{\linkS4class{Milo}} object with a valid \code{graph} slot.
If \code{reduced.dims} is not provided and there is no valid populated \code{reducedDim}
slot in \code{x}, then this is computed first with \code{d + 1} principal components.}

\item{d}{The number of dimensions to use for computing within-neighbourhood
distances. This should be the same value used construct the \code{graph}.}

\item{reduced.dim}{If x is an \code{\linkS4class{Milo}} object, a character indicating the name of the \code{reducedDim} slot in the
\code{\linkS4class{Milo}} object to use as (default: 'PCA'). Otherwise this should be an N X P matrix with rows in the same order as the
columns of the input Milo object \code{x}.}

\item{use.assay}{A character scalar defining which \code{assay} slot in the
\code{\linkS4class{Milo}} to use}
}
\value{
A \code{\linkS4class{Milo}} object with the distance slots populated.
}
\description{
This function will calculate Euclidean distances between single-cells in a
neighbourhood using the same dimensionality as was used to construct the graph.
This step follows the \code{makeNhoods} call to limit the number of distance
calculations required.
}
\examples{
library(SingleCellExperiment)
ux <- matrix(rpois(12000, 5), ncol=200)
vx <- log2(ux + 1)
pca <- prcomp(t(vx))

sce <- SingleCellExperiment(assays=list(counts=ux, logcounts=vx),
                            reducedDims=SimpleList(PCA=pca$x))

milo <- Milo(sce)
milo <- buildGraph(milo, d=30, transposed=TRUE)
milo <- makeNhoods(milo)
milo <- calcNhoodDistance(milo, d=30)

milo
}
\author{
Mike Morgan, Emma Dann
}
