% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeNhoods.R
\name{makeNhoods}
\alias{makeNhoods}
\title{Define neighbourhoods on a graph (fast)}
\usage{
makeNhoods(
  x,
  prop = 0.1,
  k = 21,
  d = 30,
  refined = TRUE,
  reduced_dims = "PCA",
  refinement_scheme = "reduced_dim"
)
}
\arguments{
\item{x}{A \code{\linkS4class{Milo}} object with a non-empty \code{graph}
slot. Alternatively an \code{igraph} object on which neighbourhoods will
be defined.}

\item{prop}{A double scalar that defines what proportion of graph vertices
to randomly sample. Must be 0 < prop < 1.}

\item{k}{An integer scalar - the same k used to construct the input graph.}

\item{d}{The number of dimensions to use if the input is a matrix of cells
X reduced dimensions.}

\item{refined}{A logical scalar that determines the sampling behavior, default=TRUE implements a refined sampling scheme,
specified by the refinement_scheme argument.}

\item{reduced_dims}{If x is an \code{\linkS4class{Milo}} object, a character indicating the name of the \code{reducedDim} slot in the
\code{\linkS4class{Milo}} object to use as (default: 'PCA'). If x is an \code{igraph} object, a
matrix of vertices X reduced dimensions with \code{rownames()} set to correspond to the cellIDs.}

\item{refinement_scheme}{A character scalar that defines the sampling scheme, either "reduced_dim" or "graph".
Default is "reduced_dim".}
}
\value{
A \code{\linkS4class{Milo}} object containing a list of vertices and
the indices of vertices that constitute the neighbourhoods in the
nhoods slot. If the input is a \code{igraph} object then the output
is a matrix containing a list of vertices and the indices of vertices that constitute the
neighbourhoods.
}
\description{
This function randomly samples vertices on a graph to define neighbourhoods.
These are then refined by either computing the median profile for the neighbourhood
in reduced dimensional space and selecting the nearest vertex to this
position (refinement_scheme = "reduced_dim"), or by computing the vertex with the highest number of
triangles within the neighborhood (refinement_scheme = "graph").
Thus, multiple neighbourhoods may be collapsed down together to
prevent over-sampling the graph space.
}
\details{
This function randomly samples graph vertices, then refines them to collapse
down the number of neighbourhoods to be tested. The refinement behaviour can
be turned off by setting \code{refine=FALSE}, however, we do not recommend
this as neighbourhoods will contain a lot of redundancy and lead to an
unnecessarily larger multiple-testing burden.
}
\examples{

require(igraph)
m <- matrix(rnorm(100000), ncol=100)
milo <- buildGraph(m, d=10)

milo <- makeNhoods(milo, prop=0.1)
milo

}
\author{
Emma Dann, Mike Morgan
}
