% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testDiffExp.R
\name{testDiffExp}
\alias{testDiffExp}
\title{Perform post-hoc differential gene expression analysis}
\usage{
testDiffExp(
  x,
  da.res,
  design,
  meta.data,
  model.contrasts = NULL,
  assay = "logcounts",
  subset.nhoods = NULL,
  subset.row = NULL,
  gene.offset = TRUE,
  n.coef = NULL,
  na.function = "na.pass"
)
}
\arguments{
\item{x}{A \code{\linkS4class{Milo}} object containing single-cell gene expression
and neighbourhoods.}

\item{da.res}{A \code{data.frame} containing DA results, as expected from running
\code{testNhoods}.}

\item{design}{A \code{formula} or \code{model.matrix} object describing the
experimental design for differential gene expression testing. The last component
of the formula or last column of the model matrix are by default the test
variable. This behaviour can be overridden by setting the \code{model.contrasts}
argument. This should be the same as was used for DA testing.}

\item{meta.data}{A cell X variable \code{data.frame} containing single-cell meta-data
to which \code{design} refers. The order of rows (cells) must be the same as the
\code{\linkS4class{Milo}} object columns.}

\item{model.contrasts}{A string vector that defines the contrasts used to perform
DA testing. This should be the same as was used for DA testing.}

\item{assay}{A character scalar determining which \code{assays} slot to extract from the
\code{\linkS4class{Milo}} object to use for DGE testing.}

\item{subset.nhoods}{A logical, integer or character vector indicating which neighbourhoods
to subset before aggregation and DGE testing (default: NULL).}

\item{subset.row}{A logical, integer or character vector indicating the rows
of \code{x} to use for sumamrizing over cells in neighbourhoods.}

\item{gene.offset}{A logical scalar the determines whether a per-cell offset
is provided in the DGE GLM to adjust for the number of detected genes with
expression > 0.}

\item{n.coef}{A numeric scalar refering to the coefficient to select from the
DGE model. This is especially pertinent when passing an ordered variable and
only one specific type of effects are to be tested.}

\item{na.function}{A valid NA action function to apply, should be one of
\code{na.fail, na.omit, na.exclude, na.pass}.}
}
\value{
A \code{list} containing a \code{data.frame} of DGE results for each aggregated
group of neighbourhoods.
}
\description{
This function will perform differential gene expression analysis within
differentially abundant neighbourhoods, by first aggregating adjacent and
concordantly DA neighbourhoods, then comparing cells \emph{within} these
aggregated groups for differential gene expression using the input design. For
comparing \emph{between} DA neighbourhoods see \code{\link{findNhoodMarkers}}.
}
\details{
Adjacent neighbourhoods are first merged based on two criteria: 1) they share at
least \code{overlap} number of cells, and 2) the DA log fold change sign is concordant.
This behaviour can be modulated by setting \code{overlap} to be more or less stringent.
Additionally, a threshold on the log fold-changes can be set, such that \code{lfc.threshold}
is required to merge adjacent neighbourhoods. Note: adjacent neighbourhoods will never be
merged with opposite signs unless \code{merge.discord=TRUE}.

Within each aggregated group of cells differential gene expression testing is performed
using the single-cell log normalized gene expression with a GLM
(for details see \code{\link[limma]{limma-package}}), or the single-cell counts using a
negative binomial GLM (for details see \code{\link[edgeR]{edgeR-package}}). When using
single-cell data for DGE it is recommended to set \code{gene.offset=TRUE} as this
behaviour adjusts the model by the number of detected genes in each cell as a proxy for
differences in capture efficiency and cellular RNA content.
}
\examples{
data(sim_discrete)

milo <- Milo(sim_discrete$SCE)
milo <- buildGraph(milo, k=20, d=10, transposed=TRUE)
milo <- makeNhoods(milo, k=20, d=10, prop=0.3)

meta.df <- sim_discrete$meta
meta.df$SampID <- paste(meta.df$Condition, meta.df$Replicate, sep="_")
milo <- countCells(milo, meta.data=meta.df, samples="SampID")

test.meta <- data.frame("Condition"=c(rep("A", 3), rep("B", 3)), "Replicate"=rep(c("R1", "R2", "R3"), 2))
test.meta$Sample <- paste(test.meta$Condition, test.meta$Replicate, sep="_")
rownames(test.meta) <- test.meta$Sample
da.res <- testNhoods(milo, design=~Condition, design.df=test.meta[colnames(nhoodCounts(milo)), ])
da.res <- groupNhoods(milo, da.res, da.fdr=0.1)
nhood.dge <- testDiffExp(milo, da.res, design=~Condition, meta.data=meta.df)
nhood.dge

}
\author{
Mike Morgan & Emma Dann
}
