% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/view_pathways.R
\name{plot_augmented_pathway}
\alias{plot_augmented_pathway}
\title{Plotting of augmented pathway}
\usage{
plot_augmented_pathway(original_pathway, augmented_pathway,
  pathway_name = " ", ...)
}
\arguments{
\item{original_pathway}{A
graph::graphNEL object where each of the nodes is named with '<gene_ID>'.
Nodes of each graph::graphNEL represent the genes involved in the 
pathway and edges represent the biological interactions (activation or
repression) among those genes.}

\item{augmented_pathway}{A
graph::graphNEL object where each of the nodes is named with '<gene_ID>'.
Nodes of each graph::graphNEL represent genes 
and miRNAs involved in the 
pathway and edges represent the biological interactions (activation or
repression) among them.}

\item{pathway_name}{The name of the pathway.}

\item{...}{Other arguments for the '<plotPathway2Colors>' function.}
}
\value{
A plot of one augmented pathway with the new nodes
highlighted in black.
}
\description{
Functions for plotting a particular augmented pathway. In the plot,
miRNAs that were
added to the original pathway are differentiated from proteins that were 
originally in the
pathway. Blue boxes represent the proteins that were part of the
original
pathway, and black boxes represent the miRNAs that were added during 
augmentation.
}
\examples{
data(augmented_pathways)
data(kegg_pathways)
data(names_pathways) 

plot_augmented_pathway(kegg_pathways[[18]], augmented_pathways[[18]],
                      pathway_name = names_pathways[[18]])

}
\author{
Diana Diaz <dmd at wayne dot edu>
}

