% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GO_terms_analysis.R
\name{find_enriched_go_terms}
\alias{find_enriched_go_terms}
\alias{create_go_term_mapping}
\title{Find enriched GO terms}
\usage{
find_enriched_go_terms(
  assignments,
  gene_id_to_go,
  ontology = "BP",
  weighted = FALSE,
  node_size = 10
)

create_go_term_mapping(genes, gene_col = "refseq_mrna")
}
\arguments{
\item{assignments}{boolean named vector determining the gene subset to be
tested for enrichment of GO terms. The names of the vector should be the
gene names. Elements with TRUE will consist of the gene cluster.}

\item{gene_id_to_go}{List giving the Gene ID to GO object required for topGO
(see \code{\link[topGO]{topGOdata-class}}). 
\code{create_go_term_mapping} can construct such a list from a
data-frame.}

\item{ontology}{string, optional, default: BP. specficies which ontology to
use (passed to \code{ontology} argument in creating a new \code{topGOdata}
object). Can be 'BP', 'CC', or 'NF'. See
\code{\link[topGO]{topGOdata-class}}.}

\item{weighted}{boolean, optional, default: FALSE. Whether to use the
weighted algorithm or not in \code{\link[topGO]{runTest}}.}

\item{node_size}{integer, optional, default: 10. Consider only GO terms with
node_size number of genes, passed to \code{nodeSize} argument of
\code{\link[topGO]{topGOdata-class}}}

\item{genes}{dataframe, with two required columns. The first gives the gene
names, with column name by the argument \code{gene_col}. The other column
must be named "go_id" and give the genes GO id. Genes will have multiple GO
id that they map to, and each go mapping of a gene is a separate row. Thus
genes will be in multiple rows of the input.}

\item{gene_col}{the name of the column of the \code{genes} data frame that
contains the correct gene reference. By default, is "refseq_mrna".}
}
\value{
Returns results in the format of \code{\link[topGO]{GenTable}}.

\code{create_go_term_mapping} returns a list giving the gene to GO id
  in the format required by \code{\link[topGO]{topGOdata-class}}.
}
\description{
Find enriched GO terms

Create the Gene to GO Term mapping
}
\details{
\code{find_enriched_go_terms} is a wrapper for running a GO
 enrichment analysis via the package \code{topGO}. This function creates a
 \code{\link[topGO]{topGOdata-class}} object, runs the function
 \code{\link[topGO]{runTest}} to test for enrichment using the
 \code{statistic="fisher"} option, and then runs
 \code{\link[topGO]{GenTable}}. This function then does some post-processing
 of the results, returning only GO terms that satisfy:
 \enumerate{
 \item{BH adjusted p-values less than 0.05 using
 \code{\link[stats]{p.adjust}}}
 \item{GO terms are \emph{enriched}, i.e. the number of genes from the GO 
 term found in the subset is greater than expected}
 }
}
\examples{
data(exampleData)
head(testGenesGO) #gives the mapping of genes to GO
geneId2Go <- create_go_term_mapping(testGenesGO)
#create fake assignment of genes to group based on TRUE/FALSE values
inGroup=rep(FALSE,nrow(testData))
inGroup[1:10]=TRUE
names(inGroup) <- row.names(testData)
find_enriched_go_terms(inGroup, geneId2Go)
}
\seealso{
\code{\link{create_go_term_mapping}}, \code{\link[KEGGprofile]{find_enriched_pathway}}, \code{\link[topGO]{GenTable}}, \code{\link[topGO]{runTest}}, \code{\link[topGO]{topGOdata-class}}, \code{\link[stats]{p.adjust}}
}
