% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RNAfeatures.R
\name{RNAfeatures}
\alias{RNAfeatures}
\title{Summarise the distribution of sRNA clusters across genomic features}
\usage{
RNAfeatures(
  data,
  annotation,
  repeats = NULL,
  promoterRegions = 1000,
  percentage = TRUE,
  repeat.type = NULL
)
}
\arguments{
\item{data}{data.frame; generated by \code{\link[=RNAimport]{RNAimport()}}}

\item{annotation}{path; URL or connection to a GFFFile object. A genome
reference annotation file (.gff/.gff1/.gff2/.gff3). Can be in compressed
format (gzip).}

\item{repeats}{path; URL or connection to a GFFFile object. A genome
reference annotation file, which only contains information on repeat
sequences in the genome (.gff/.gff1/.gff2/.gff3). By default, this is not
required, however if there is a specific repeats annotation file for the
genome it is suggested to supply it. Can be in compressed format (gzip).}

\item{promoterRegions}{numeric; defines the upstream promoter region of
genes. Default is 1000, which refers to promoters set at 1Kb upstream of
genes}

\item{percentage}{logical; define whether to return the results as a
percentage of the total or returned as a count value representing the
number of sRNA clusters that overlap with a given genomic feature. Default is
\code{TRUE}.}

\item{repeat.type}{character; features type in \code{annotation} file to represent
repeats or transposable elements when \code{repeats} not supplied. Default is
\verb{c("transposable_element", transposable_element_gene")} which represent the
transposable element features in the TAIR10 genome annotation.}
}
\value{
Returns a table containing the number or percentage of overlaps in
the supplied sRNA data set with specific regions in the genome annotation
such as genes, repeats, introns, exons.
}
\description{
Calculates the number of genomic features within the supplied
annotations and calculates the number of sRNA clusters which overlap with
these genomic features. Features include promoter regions, repeat regions,
exons, introns, and untranslated regions. This can be summarised as the
absolute or relative values.
}
\details{
\code{RNAfeatures} calculates the number or percentage of sRNA clusters which
overlap with genomic features based on their genomic coordinates.
}
\examples{
data("sRNA_data")
features <- RNAfeatures(data = sRNA_data,
                       annotation = system.file("extdata",
                       "reduced_chr2_Tomato.gff.gz", package="mobileRNA"))
                       
}
\seealso{
\code{\link[=RNAmergeAnnotations]{RNAmergeAnnotations()}} to merge 2 GFF files into 1.
}
