% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motif_enrichment_HOMER.R
\name{parseHomerOutput}
\alias{parseHomerOutput}
\title{Load output from HOMER findMotifsGenome.pl into R}
\usage{
parseHomerOutput(infiles, pseudocount.log2enr = 8, p.adjust.method = "BH")
}
\arguments{
\item{infiles}{HOMER output files to be parsed.}

\item{pseudocount.log2enr}{A numerical scalar with the pseudocount to add to
foreground and background counts when calculating log2 motif enrichments}

\item{p.adjust.method}{A character scalar selecting the p value adjustment
method (used in \code{\link[stats]{p.adjust}}).}
}
\value{
A list of nine components (\code{negLog10P}, \code{negLog10Padj},
    \code{pearsonResid}, \code{expForegroundWgtWithHits}, \code{log2enr},
    \code{sumForegroundWgtWithHits} and \code{sumBackgroundWgtWithHits}),
    seven containing each a motif (rows) by bin (columns) matrix with raw
    -log10 P values, -log10 adjusted P values, the expected number of
    foreground sequences with hits, the observed number of foreground and
    background sequences with hits,
    and motif enrichments as Pearson residuals (\code{pearsonResid}) and as
    log2 ratios (\code{log2enr}), and two containing the total foreground
    and background weight (\code{totalWgtForeground},
    \code{totalWgtBackground}).
}
\description{
Parse HOMER output files into R data structures.
}
\examples{
outfile <- system.file("extdata", "homer_output.txt.gz",
                       package = "monaLisa")
res <- parseHomerOutput(infiles = c(bin1 = outfile))
head(res$negLog10P)

}
