% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{distance_matrix}
\alias{distance_matrix}
\title{Compute distances between biclusters}
\usage{
distance_matrix(bics, MARGIN = "row", metric = 1L)
}
\arguments{
\item{bics}{A list of bicluster objects.}

\item{MARGIN}{Choose if the distance is computed over \code{"row"} 
or \code{"column"}.}

\item{metric}{Integer indicating which metric is used. 1: Bray-Curtis 
dissimilarity (default), 2: Jaccard distance, 3: 1-overlap coefficient  
4: 1 - Fowlkes–Mallows index.}
}
\value{
A numeric matrix of the dissimilarities between all 
given biclusters.
}
\description{
This function computes a distance matrix between biclusters using 
different dissimilarity metrics.
}
\examples{
b <- list(bicluster(row=c(1,2,3,4), column=c(1,2,3,4)),
        bicluster(row=c(3,4,5,6), column=c(3,4,5,6)))
distance_matrix(b)

}
