% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getRankedUniqueMotifs.R
\name{getRankedUniqueMotifs}
\alias{getRankedUniqueMotifs}
\title{get the unique motif in each category grouped by distance}
\usage{
getRankedUniqueMotifs(phylog, attr)
}
\arguments{
\item{phylog}{an object of class phylog}

\item{attr}{attribute used for category of motifs}
}
\value{
return a list: \item{uni.rank}{unique motif ranks}
\item{uni.length}{length of unique motif grouped by distance}
\item{uni.list}{unique motif names grouped by distance}
}
\description{
to get the unique motif in a given category, eg by species.
}
\examples{

   if(interactive() || Sys.getenv("USER")=="jianhongou"){
        library("MotifDb")
        matrix.fly <- query(MotifDb, "Dmelanogaster")
        matrix.human <- query(MotifDb, "Hsapiens")
        pfms <- c(as.list(matrix.fly), as.list(matrix.human))
        pfms <- pfms[sample(seq_along(pfms), 100)]
        hc <- clusterMotifs(pfms)
        library(ade4)
        phylog <- ade4::hclust2phylog(hc)
        leaves <- names(phylog$leaves)
        attr <- gsub("^(.*?)_.*$", "\1", leaves)
        getRankedUniqueMotifs(phylog, attr)
    }

}
\author{
Jianhong Ou
}
\keyword{misc}
