% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{motifbreakR_motif}
\alias{motifbreakR_motif}
\title{MotifDb object containing motif information from the motif databases of HOCOMOCO, Homer,
 FactorBook and ENCODE}
\format{
\code{\link[MotifDb]{MotifDb}} object of length 2816; to access metadata
use mcols(motifbreakR_motif)
}
\source{
Kulakovskiy,I.V., Medvedeva,Y.A., Schaefer,U., Kasianov,A.S.,
  Vorontsov,I.E., Bajic,V.B. and Makeev,V.J. (2013) HOCOMOCO: a comprehensive
  collection of human transcription factor binding sites models. Nucleic
  Acids Research, \bold{41}, D195--D202.

Heinz S, Benner C, Spann N, Bertolino E et al. (2010 May 28) Simple Combinations
  of Lineage-Determining Transcription Factors Prime cis-Regulatory
  Elements Required for Macrophage and B Cell Identities. Mol Cell, \bold{38(4):576-589}.
  PMID: \href{http://www.ncbi.nlm.nih.gov/sites/entrez?Db=Pubmed&term=20513432[UID]}{20513432}

J Wang, J Zhuang, S Iyer, XY Lin, et al. (2012) Sequence features and
  chromatin structure around the genomic regions bound by 119 human transcription
  factors. Genome Research, \bold{22 (9)}, 1798-1812, doi:10.1101/gr.139105.112

Pouya Kheradpour and Manolis Kellis (2013 December 13) Systematic
  discovery and characterization of regulatory motifs in ENCODE TF binding
  experiments. Nucleic Acids Research, doi:10.1093/nar/gkt1249
}
\usage{
motifbreakR_motif
}
\value{
\code{\link[MotifDb]{MotifList-class}} object
}
\description{
This object contains all the \code{\link[MotifDb]{MotifList-class}} objects that were generated
for this package.  See the individual help sections for \code{\link{hocomoco}}, \code{\link{homer}},
\code{\link{factorbook}}, and \code{\link{encodemotif}}, for how the data is formatted.
}
\details{
Load with \code{data(motifbreakR_motif)}
}
\examples{
data(motifbreakR_motif)
motifbreakR_motif
}
\seealso{
\code{\link{hocomoco}}, \code{\link{homer}},
\code{\link{factorbook}}, and \code{\link{encodemotif}}
}
\keyword{datasets}
