% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combinatorial_wrapper.R
\name{combinatorialDist}
\alias{combinatorialDist}
\title{Combinatrial model approximation of the number of motif hits}
\usage{
combinatorialDist(seqlen, overlap)
}
\arguments{
\item{seqlen}{Integer-valued vector that defines the lengths of the
individual sequences. For a given DNAStringSet, 
this information can be retrieved using \code{\link{numMotifHits}}.}

\item{overlap}{An Overlap object.}
}
\value{
List containing
\describe{
\item{dist}{Distribution of the number of hits}
}
}
\description{
This function approxmiates the distribution of the number of motif hits.
To this end, it sums over all combinations of obtaining k hits 
in a random sequence of a given length using an efficient 
dynamic programming algorithm.
}
\details{
This function is an alternative to \code{\link{compoundPoissonDist}}
which requires fixed-length sequences and currently
only supports the computation of 
the distribution of the number of hits when both
DNA strands are scanned for motif hits.
}
\examples{

# Load sequences
seqfile = system.file("extdata", "seq.fasta", package = "motifcounter")
seqs = Biostrings::readDNAStringSet(seqfile)

# Load motif
motiffile = system.file("extdata", "x31.tab", package = "motifcounter")
motif = t(as.matrix(read.table(motiffile)))

# Load background model
bg = readBackground(seqs, 1)

# Compute overlap probabilities
op = motifcounter:::probOverlapHit(motif, bg, singlestranded = FALSE)

# Use 2 sequences of length 100 bp each
seqlen = rep(100, 2) 

# Computes the combinatorial distribution of the number of motif hits
dist = motifcounter:::combinatorialDist(seqlen, op)

}
\seealso{
\code{\link{compoundPoissonDist}}

\code{\link{numMotifHits}}

\code{\link{probOverlapHit}}
}
